using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

using gov.va.med.vbecs.BOL;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmProlongedTransfusionReport
	/// </summary>
    public class FrmProlongedTransfusionReport : gov.va.med.vbecs.GUI.VbecsBaseForm /*gov.va.med.vbecs.GUI.FrmBaseSinglePageReport*/
	{
        private ProlongedTransfusionReport _reportData;
        private GroupBox grpImage;
        private PictureBox pictureBox2;
        private Button btnCancel;
        private Button btnPrint;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvProlongedTransfusion;
        private DataTable _dtReport = new DataTable();

		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmProlongedTransfusionReport(BOL.ProlongedTransfusionReport prolongedTransfusionReport)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 

			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC105.FrmProlongedTransfusionReport());
            this._reportData = prolongedTransfusionReport;
            BOL.VbecsReport.SetUpReportButtons(this.rvProlongedTransfusion);
            this.CreateReport();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmProlongedTransfusionReport));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.rvProlongedTransfusion = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Title = "Prolonged Transfusion Time Report";
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.pictureBox2);
            this.grpImage.Location = new System.Drawing.Point(1, 31);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 411);
            this.grpImage.TabIndex = 70;
            this.grpImage.TabStop = false;
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(4, 8);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(45, 45);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox2.TabIndex = 1;
            this.pictureBox2.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(564, 447);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 71;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 447);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 72;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // rvProlongedTransfusion
            // 
            this.rvProlongedTransfusion.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvProlongedTransfusion.Location = new System.Drawing.Point(57, 37);
            this.rvProlongedTransfusion.Name = "rvProlongedTransfusion";
            this.rvProlongedTransfusion.Size = new System.Drawing.Size(582, 404);
            this.rvProlongedTransfusion.TabIndex = 73;
            // 
            // FrmProlongedTransfusionReport
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvProlongedTransfusion);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.grpImage);
            this.hlphelpChm.SetHelpKeyword(this, "Prolonged_Transfusion_Time_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Name = "FrmProlongedTransfusionReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Load += new System.EventHandler(this.FrmProlongedTransfusionReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.rvProlongedTransfusion, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion


        /// <summary>
        /// Create Report
        /// </summary>
        public void CreateReport()
        {
            _dtReport = this._reportData.GetReportData();
            _dtReport.TableName = "ProlongedTransfusion";
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this._reportData.GetReportCriteriaText());

            #if DEBUG
                        //_dtReport.WriteXml("e:\\temp\\ProlongedTransfusionDataSet.xml", XmlWriteMode.WriteSchema);
            #endif

            ReportDataSource reportSourceMain = new ReportDataSource();
            reportSourceMain.Name = "ProlongedTransfusionTimeDataSet";
            reportSourceMain.Value = _dtReport;
            
            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ProlongedTransfusionTime.ProlongedTransfusionTimeReport.rdlc");

            this.rvProlongedTransfusion.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvProlongedTransfusion.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvProlongedTransfusion.LocalReport.DataSources.Add(reportSourceMain);
            this.rvProlongedTransfusion.LocalReport.LoadReportDefinition(stream);

            this.rvProlongedTransfusion.RefreshReport();
            
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            try
            {
                this.rvProlongedTransfusion.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }
        
        private void FrmProlongedTransfusionReport_Load(object sender, EventArgs e)
        {

            this.rvProlongedTransfusion.RefreshReport();
        }
	}
}

